%
% This script produces TeX output for a table.
%

m = 4096;
n = 2*m;
l = min(m,n);

fileID = fopen('table3.txt','w');
fprintf(fileID,'$j$ & $k$ & $\\delta$ & $\\epsilon$ & $t$ \\\\\\hline\\hline\n')

for eps = [.1e-2 .1e-10]
  for k = [2 10]

    k
    eps

%
%   Set the singular values.
%
    Sig = zeros(m,n);
    for j = 1:k
      s(j) = eps^(floor(j/2)/(k/2));
      Sig(j,j) = s(j);
    end
    for j = (k+1):l
      s(j) = s(k)*(l-j)/(l-k-1);
      Sig(j,j) = s(j);
    end

%
%   Construct the matrix to be approximated.
%
    A = fft(fft(Sig')')/sqrt(m*n);

%
%   Approximate the matrix and estimate its accuracy.
%
    for its = [0 1 2 10]
      raw = true;
      tic;
      [P,Q] = als(A,k,raw,its);
      t = toc
      err = powmeth(A,P,Q,100)
%
%     Output a table for TeX.
%
      fprintf(fileID, '%2d & %2d & %1.0e & %2.1e & %2.1e \\\\\n', ...
        its, k, eps, err, t)
    end

    fprintf(fileID, '\\hline\n')

  end
end

fclose(fileID)
