%
% This script tests als on dense matrices.
%

err = [];

for m = [10 20]
  for n = [10 20]
    for k = [3 8]
      for its = [0 2 1000]
        for raw = [true false]
          for isreal = [true false]


            l = k+1;


            if(isreal)
              U = randn(m,k);
              U = qr(U,0);
              V = randn(n,k);
              V = qr(V,0);
            end

            if(~isreal)
              U = randn(m,k) + i*randn(m,k);
              U = qr(U,0);
              V = randn(n,k) + i*randn(n,k);
              V = qr(V,0);
            end


            S = zeros(k,k);
            S(1,1) = 1;
            S(2,2) = .1;
            S(3,3) = .01;


            A = U*S*V';


            [P,Q] = als(A,k,raw,its,l);


            if(raw)
              err = [err powmeth(A,P,Q)];
            end
            if(~raw)
              err = [err powmethc(A,P,Q)];
            end


          end
        end
      end
    end
  end
end

err


if(all(err<.1d-10))
  disp('All tests succeeded.');
end

if(~all(err<.1d-10))
  error('A test failed.');
end
